/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.calendar;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWDateTimeException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class VWDateTimeFormat {
    private static DateFormat[] s_dateTimeFormatters = new DateFormat[]{DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateTimeInstance(3, 2), DateFormat.getDateTimeInstance(3, 1), DateFormat.getDateTimeInstance(3, 0), DateFormat.getDateTimeInstance(2, 3), DateFormat.getDateTimeInstance(2, 2), DateFormat.getDateTimeInstance(2, 1), DateFormat.getDateTimeInstance(2, 0), DateFormat.getDateTimeInstance(1, 3), DateFormat.getDateTimeInstance(1, 2), DateFormat.getDateTimeInstance(1, 1), DateFormat.getDateTimeInstance(1, 0), DateFormat.getDateTimeInstance(0, 3), DateFormat.getDateTimeInstance(0, 2), DateFormat.getDateTimeInstance(0, 1), DateFormat.getDateTimeInstance(0, 0)};

    public static Date getDateObject(String dateTimeString) throws VWDateTimeException {
        Date date = null;
        boolean success = false;
        int dateFormatterCount = s_dateTimeFormatters.length;
        if (dateFormatterCount > 0) {
            for (int i = 0; i < dateFormatterCount && !success; ++i) {
                try {
                    date = s_dateTimeFormatters[i].parse(dateTimeString);
                    success = true;
                    continue;
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
        }
        return date;
    }

    public static String getDateString(Date date) {
        String dateString = null;
        DateFormat dateFormatter = DateFormat.getDateInstance(2);
        dateString = dateFormatter.format(date);
        return dateString;
    }

    public static String getTimeString(Date date) {
        String timeString = null;
        DateFormat timeFormatter = DateFormat.getTimeInstance(2);
        timeString = timeFormatter.format(date);
        return timeString;
    }

    public static String convertSecondsToTimeString(long seconds) {
        String time = null;
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.set(2002, 1, 1, 0, 0, 0);
            Date temp = calendar.getTime();
            Date dateTime = new Date(temp.getTime() + seconds * 1000L);
            time = VWDateTimeFormat.getTimeString(dateTime);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return time;
    }

    public static long convertTimeStringToSeconds(String time) {
        long seconds = 0L;
        try {
            Date now = new Date();
            String date = VWDateTimeFormat.getDateString(now);
            String dateTime = date + " " + time;
            String morning = date + " 00:00 AM";
            Date currentTime = VWDateTimeFormat.getDateObject(dateTime);
            Date morningTime = VWDateTimeFormat.getDateObject(morning);
            if (currentTime != null && morningTime != null) {
                seconds = (currentTime.getTime() - morningTime.getTime()) / 1000L;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return seconds;
    }
}

